function [pourc, Resume, Dcoeff, beta] = classification_simu(TRACKS, T, t_msd, tau, tau_space, name, model)

% It performs the classification of mouvement for tracks contained in
% TRACKS.
%
% OUTPUT :
% - it displies all tracks with color depending on mouvement; on the same figure 
%   it writes the percentage
% - for every class of mouvement, it creates a csv file containing the
%   following coloumns 
%   [ #track |t | X | Y |intensity |area | type mouvement |  original track | Stat | Ext | Dcoeff, S_mss | mean intensity | mean surface]
%   type mouvement = 1 (conf), 2 (dir), 3 (brow), 4 (imm)                      
[ M_brow, M_dir, M_conf, M_imm, Stat, Ext, Dcoeff, S_mss, pourc, Resume, EXT, beta] = motion_classification_simu(TRACKS,  T, t_msd, tau, tau_space, name, model);


n_conf=numel(M_conf);
n_dir=numel(M_dir);
n_brow=numel(M_brow);
n_imm=numel(M_imm);
FINAL_TRACKS=[];


    fig=figure;
    %title(['Classification of ', name, ' tracks  by the statistical method'])
   
    count =1;
    CONF=[];
    TRACKS_CONF=[];
    A=[];
    for k=1:n_conf
       
        ind=M_conf(k);
        X=TRACKS(ind).coord(1,:);
        Y=TRACKS(ind).coord(2,:);
        TRACKS_CONF(count).coord = TRACKS(ind).coord;
        track_orig = TRACKS(ind).orig;
        times = TRACKS(ind).times;
        
        hold on
        plot(X,-Y, 'b');

        A=[NaN.*ones(3+numel(X),7)];
        A(1,1)=count;
        A(1,7:14)=[1, track_orig, Stat(ind), Ext(ind), Dcoeff(ind), S_mss(ind), mean(TRACKS(ind).int'), mean(TRACKS(ind).surf')];
        A(3:2+numel(X),2)=times';       
        A(3:2+numel(X),3:6)=[X',Y', TRACKS(ind).int',TRACKS(ind).surf'];
        CONF=[CONF;A];
        count=count+1;
    end
    count =1;
    TRACKS_DIR=[];
    DIR=[];
    A=[];
    for k=1:n_dir
        ind=M_dir(k);
        X=TRACKS(ind).coord(1,:);
        Y=TRACKS(ind).coord(2,:);
        TRACKS_DIR(count).coord = TRACKS(ind).coord;
        track_orig = TRACKS(ind).orig;
        times = TRACKS(ind).times;
        
        hold on
        darkgreen = [0 .5 0];
        plot(X,-Y, 'Color', darkgreen);

        A=[NaN.*ones(3+numel(X),7)];
        A(1,1)=count;
        A(1,7:14)=[2,track_orig, Stat(ind), Ext(ind), Dcoeff(ind),  S_mss(ind), mean(TRACKS(ind).int'), mean(TRACKS(ind).surf')];
        A(3:2+numel(X),2)=times';       
        A(3:2+numel(X),3:6)=[X',Y', TRACKS(ind).int',TRACKS(ind).surf'];
        DIR=[DIR;A];
        count=count+1;
    end
    count =1;
    BROW=[];
    TRACKS_BROW=[];
    A=[];
    for k=1:n_brow
        ind=M_brow(k);
        X=TRACKS(ind).coord(1,:);
        Y=TRACKS(ind).coord(2,:);
        TRACKS_BROW(count).coord = TRACKS(ind).coord;
        track_orig = TRACKS(ind).orig;
        times = TRACKS(ind).times;
        
        hold on
        plot(X,-Y, 'r');

        A=[NaN.*ones(3+numel(X),7)];
        A(1,1)=count;
        A(1,7:14)=[3,track_orig, Stat(ind), Ext(ind), Dcoeff(ind),S_mss(ind), mean(TRACKS(ind).int'), mean(TRACKS(ind).surf')];
        A(3:2+numel(X),2)=times';       
        A(3:2+numel(X),3:6)=[X',Y', TRACKS(ind).int',TRACKS(ind).surf'];
        BROW=[BROW;A];
        count=count+1;
    end
    count =1;
    IMM=[];
    TRACKS_IMM=[];
    A=[];
     for k=1:n_imm
        ind=M_imm(k);
        X=TRACKS(ind).coord(1,:);
        Y=TRACKS(ind).coord(2,:);
        TRACKS_IMM(count).coord = TRACKS(ind).coord;
        track_orig = TRACKS(ind).orig;
        times = TRACKS(ind).times;
        
        hold on
        plot(X,-Y, 'k');

        A=[NaN.*ones(3+numel(X),7)];
        A(1,1)=count;
        A(1,7:14)=[4,track_orig, Stat(ind), Ext(ind), Dcoeff(ind), S_mss(ind), mean(TRACKS(ind).int'), mean(TRACKS(ind).surf')];
        A(3:2+numel(X),2)=times';       
        A(3:2+numel(X),3:6)=[X',Y', TRACKS(ind).int',TRACKS(ind).surf'];
        IMM=[IMM;A];
        count=count+1;
     end
     
S0=['(blue)   ';'(green)  ';'(red)    ';'(black)  ';'         ' ];
   S1=['Conf=';'Dir =';'Brow=';'Immo='; 'nbtr='];
   String=[S0,S1];
   S = [String,num2str(pourc')];
   descr={S};
   ax1 = axes('Position',[0 0 1 1],'Visible','off');
   axes(ax1) % sets ax1 to current axes
   text(.8,0.8,descr)   

namefile = ['./RESULTS/' name '-classification.eps'];
   saveas(fig, namefile);
   print('-depsc', namefile);

   
    % Control empty files
   
   if isempty(CONF)==1
       CONF=NaN.*ones(2,14);
   end
   if isempty(DIR)==1
       DIR=NaN.*ones(2,14);
   end
   if isempty(IMM)==1
       IMM=NaN.*ones(2,14);
   end
   if isempty(BROW)==1
       BROW=NaN.*ones(2,14);
   end
   
  % Excel file

%    save_name=['./RESULTATS/' name '-CONF.xls'] ;
%    xlswrite(save_name,CONF)
% 
%    save_name=['./RESULTATS/' name '-DIR.xls'] ;
%    xlswrite(save_name,DIR)
% 
%    save_name=['./RESULTATS/' name '-IMM.xls'] ;
%    xlswrite(save_name,IMM)
% 
%    save_name=['./RESULTATS/' name '-BROW.xls'] ;
%    xlswrite(save_name,BROW)
%    
%    ALL = [CONF; DIR; BROW; IMM];
%    
%    save_name=['./RESULTATS/' name '-ALL.xls'] ;
%    xlswrite(save_name,ALL)
%    
%       
%    save_name=['./RESULTATS/' name '-Resume.xls'] ;
%    xlswrite(save_name,Resume)
%    
%    
  % String of percentage
  
  S2 = ['conf= '; 'dir = ' ; 'brow= '; 'imm=  '; 'nbtr= '];
  PERCENTAGE = [S2,num2str(pourc')];
  
  

end

